/***********************************************************************
*
* autolaunch header file. -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
***********************************************************************/

#define productionVersion 1

#define __fmdLib__
#include <fakeModalDialog.h>

#if productionVersion
#define initPtrCheck(x);
#define closePtrCheck();
#define zapLocals();
#define checkForHit();
#endif

extern pascal void	handleKeys();

/**********************************************************************/

/* The ifdef below allows the definitions to be external, except
** for the globals file.  This way, everybody can use autolaunch.h.
*/

#ifdef __globals__
#define cextern
#else
#define cextern extern
#endif

#ifndef __QUICKDRAW__
#include <quickdraw.h>
#endif

#ifndef __PRINT__
#include <print.h>
#endif

#ifndef __GSOS__
#include <gsos.h>
#endif

/********************************************************/

#define MainWindowID	0x1000L
#define AppLaunch		1L
#define AppTriggerText	10L
#define AppTriggerData	11L
#define AppTargetText	12L
#define AppTargetData	13L
#define AppTimerText	14L
#define AppTimerData	15L
#define AppUnitText		16L

#define AboutWindowID	0x2000L

/*******************************************/

#define SHORTINDEX		123

#define AppleMenuID		0x901
#define AboutItem			301

#define FileMenuID		0x902
#define CloseItem			255		/* For DA's */
#define ChooseTriggerItem	401
#define ChooseTargetItem	402
#define SaveLaunchItem		403
#define QuitItem			499

#define EditMenuID		0x903
#define UndoItem			250		/* For DA's */
#define CutItem				251		/* For DA's */
#define CopyItem			252		/* For DA's */
#define PasteItem			253		/* For DA's */
#define ClearItem			254		/* For DA's */

/***********************************************/

extern char		test[80];

#ifndef __file__
extern
#endif
unsigned int	_fileErr;

cextern unsigned int	quitFlag;			/* True when quitting */
cextern WmTaskRec		event;				/* All events are returned here */
cextern WindowPtr		mainWindow, aboutWindow;


/*********** The following structures and buffers are for file IO.  ***********/

typedef struct FileIO {
	OpenRecGS			open;		/* Used to open the file.						*/
	RefNumRecGS			close;		/* Used to close the file.						*/
	IORecGS				readWrite;	/* Use for reading and writing the file.		*/
	PositionRecGS		getPos;		/* Use for getting EOF and mark.				*/
	SetPositionRecGS	setPos;		/* Use for setting EOF and mark.				*/
	FileInfoRecGS		info;		/* Use for getting and setting file info.		*/
	CreateRecGS			create;		/* Use for creating a new file.					*/
} FileIO;

typedef struct Launch {
	char			triggerPath[514];	/* Standard file info for what files. */
	char			triggerName[34];
	char			targetPath[514];
	char			targetName[34];
	unsigned int	timer;				/* How many seconds between network checks. */
	unsigned long	dates[4];			/* 8 bytes for old date, 8 for new. */
} Launch;



cextern Launch launch;
cextern FileIO file
#ifdef __globals__
= {

	{
		3,							/* pCount				We just need 3.			*/
		0,							/* refNum				To be filled in.		*/
		NULL,						/* pathname				To be filled in.		*/
		0,							/* requestAccess		Read-only file.			*/
		0, 							/* resourceNumber		Unused					*/
		0,							/* access				Unused					*/
		0,							/* fileType				Unused					*/
		0L,							/* auxType				Unused					*/
		0,							/* storageType			Unused					*/
		{0,0,0,0,0,0,0,0},			/* createDateTime		Unused					*/
		{0,0,0,0,0,0,0,0},			/* modDateTime			Unused					*/
		NULL,						/* optionList			Unused					*/
		0L,							/* eof					Unused					*/
		0L,							/* blocksUsed			Unused					*/
		0L,							/* resourceEOF			Unused					*/
		0L							/* resourceBlocks		Unused					*/
	},

	{
		1,							/* pCount				Close just needs 1.		*/
		0							/* refNum				To be filled in.		*/
	},

	{
		4,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		(Pointer)&launch,			/* dataBuffer			Where to put the data.	*/
		sizeof(launch)-16,			/* requestCount			Max # of bytes to read.	*/
		0L, 						/* transferCount		# of bytes read.		*/
		0,							/* cachePriority		Unused					*/
	},

	{
		2,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		0L,							/* position				For GetEOF & GetMark.	*/
	},

	{
		3,							/* pCount										*/
		0,							/* refNum				To be filled in.		*/
		0,							/* base					Which disp. for pos.	*/
		0L,							/* displacement			For SetEOF & SetMark.	*/
	},

	{
		7,							/* pCount										*/
		NULL,						/* pathname				To be filled in.		*/
		3,							/* access				Read & write access		*/
		0,							/* fileType				For file filetype		*/
		0L,							/* auxType				For file auxtype		*/
		0,							/* storageType			For file storage type	*/
		{0,0,0,0,0,0,0,0},			/* createDateTime		For create date			*/
		{0,0,0,0,0,0,0,0},			/* modDateTime			For last mod date		*/
		NULL,						/* optionList			Unused					*/
		0L,							/* 						Unused					*/
		0L,							/* 						Unused					*/
		0L,							/* 						Unused					*/
		0L,							/* 						Unused					*/
	},

	{
		5,							/* pCount										*/
		NULL,						/* pathname				To be filled in.		*/
		0xC3,						/* access				Unused					*/
		0x5A,						/* fileType				Unused					*/
		0x0003,						/* auxType				Unused					*/
		1,							/* storageType			Unused					*/
		0L,							/* eof					Unused					*/
		0L							/* resourceEOF			Unused					*/
	}
}
#endif
;

